#!/bin/sh

# Check glibc compatibility
# $1: binary's filename.
# $2 (optional): glibc's filename.
# Returns: 0 on success, 1 on failure.
function checkGlibcCompat ()
{
    # Check for libc
    if [[ "$2" = '' ]]; then
        local glibc='/lib/libc.so.6'
    else
        local glibc="$2"
    fi

    # Choose the right nm commands
    if file -L "$1" | grep 'not stripped' > /dev/null 2>&1; then
        local NM1=nm
    else
        local NM1='nm -D'
    fi
    if file -L "$glibc" | grep 'not stripped' > /dev/null 2>&1; then
        local NM2=nm
    else
        local NM2='nm -D'
    fi


    # Stage 1: check for GLIBC symbols
    local APP=`$NM1 "$1" | awk '/^.* U .*@@GLIBC_.*$/ {i=index($0,"@@GLIBC_");print substr($0,i+2)}' | sed 's/ //' | sort | uniq`
    local GLIBC=`$NM2 "$glibc" | awk '/^.* A GLIBC_.*$/ {i=index($0," A GLIBC_"); print substr($0,i+3)}' | sed 's/ //' | sort | uniq`

    for S in $APP; do
        if ! echo "$GLIBC" | grep "^$S$" > /dev/null 2>&1; then
            return 1
        fi
    done


    # Stage 2: check for other stuff

    if ! $NM1 "$1" | grep -i '^.*@@GCC_.*$' > /dev/null 2>&1; then
        # No GCC_* symbols; automatically compatible
        return 0
    fi

    # Does ldd report any 'version bla bla not found errors?'
    GLIBC=`ldd "$1" 2>&1 >/dev/null`
    if echo "$GLIBC" | grep '.*: version .* not found .*' > /dev/null 2>&1; then
        return 1
    else
        return 0
    fi
}


if checkGlibcCompat "$@"; then
    echo Compatible: yes
else
    echo Compatible: no
fi
