/*
 *  libprefixdb
 *  Copyright (C) 2002-2003  Hongli Lai <h.lai@chello.nl>
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#define safe_strdup(str)  ((str) ? strdup (str) : ((void *) 0))
#define safe_free(str)  if (str) free (str)


static char *
pdbRead (PrefixDB *db, char *keyname)
{
        char *result;
        int lineno;
        FILE *f;

        f = fopen (db->dbfile, "r");
        if (!f)
                return NULL;


        result = NULL;
        lineno = 1;
        while (!feof (f))
        {
            char *line, *tmp, *key;

            line = calloc (1, PATH_MAX + 33);
            if (!fgets (line, PATH_MAX + 33, f))
                {
                    free (line);
                    goto the_end;
                }

            /* Get rid of the newline character */
            if (line[strlen (line) - 1] == 10)
                    line[strlen (line) - 1] = 0;

            /* Is this a comment or an empty line? */
            if (strlen (line) == 0 || line[0] == '#')
                {
                    free (line);
                    lineno++;
                    continue;
                }

            /* Parse line */
            tmp = strchr (line, '=');
            if (!tmp)
                {
                    fprintf (stderr, "*ERROR*: prefixdb: unable to parse line "
                             "%d in file %s\n", lineno, db->dbfile);
                    free (line);
                    lineno++;
                    continue;
                }

            key = calloc (1, tmp - line + 1);
            memcpy (key, line, tmp - line);
            if (strcmp (key, keyname) == 0)
                {
                    result = strdup (tmp + 1);
                }

            free (key);
            free (line);
            lineno++;
            if (result)
                    break;
        }


        the_end:
        fclose (f);
        return result;
}


static int
check_and_free (char *filename)
{
        struct stat buf;
        int exists;

        if (!filename)
                return 0;

        exists = stat (filename, &buf) == 0;
        free (filename);
        return exists;
}
