/*
 *  libprefixdb
 *  Copyright (C) 2002-2003  Hongli Lai <h.lai@chello.nl>
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef _PREFIXDB_H_
#define _PREFIXDB_H_


typedef struct _PrefixDB PrefixDB;


PrefixDB *pdbInit (char *domain_name_version,
                   char *prefix, char *bin, char *share,
                   char *etc,    char *lib, char *libexec);

PrefixDB *pdbInitFromFile (char *filename,
                           char *prefix, char *bin, char *share,
                           char *etc,    char *lib, char *libexec);

#define   pdbAutoInit(domain) \
                  pdbInit (domain "/" PDB_APPNAME "/" PDB_APPVERSION,\
                          PDB_PREFIX, PDB_BIN, PDB_SHARE,\
                          PDB_ETC,    PDB_LIB, PDB_LIBEXEC)

void      pdbFree (PrefixDB *db);


char *pdbGetPrefix (PrefixDB *db);
char *pdbGetBin (PrefixDB *db);
char *pdbGetShare (PrefixDB *db);
char *pdbGetEtc (PrefixDB *db);
char *pdbGetLib (PrefixDB *db);
char *pdbGetLibexec (PrefixDB *db);

/* Read an entry from the database  */
char *pdbGet (PrefixDB *db, char *name);
/* Same as pdbGet(), but returns strdup (fallback) on error */
char *pdbGetAndFbk (PrefixDB *db, char *name, char *fallback);


#endif /* _PREFIXDB_H_ */
