dnl PREFIXDB_INIT ([enabled])
dnl Enable prefixdb support.

dnl * Check for libprefixdb
dnl * Set variables
dnl * #define paths


AC_DEFUN(PREFIXDB_INIT, [
	support=no
	AC_ARG_ENABLE(prefixdb, [  --enable-prefixdb       enable libprefixdb support (default=no)],
	  support=$enableval)

	if test "$support" = "yes"; then
		PKG_CHECK_MODULES(LIBPREFIXDB, libprefixdb >= 0.1.0,,
		  AC_MSG_ERROR([libprefixdb not found]))
		LIBPREFIXDB_CFLAGS="$LIBPREFIXDB_CFLAGS -DENABLE_LIBPREFIXDB -DPDB_APPNAME=\"\\\"$PACKAGE\\\"\" -DPDB_APPVERSION=\"\\\"$VERSION\\\"\""
                enable_libprefixdb=yes


		# checkdir(dir, value, macro, ifsame, ifnotsame)
		checkdir()
		{
			if test "x${1}" = "x${2}"; then
				LIBPREFIXDB_CFLAGS="$LIBPREFIXDB_CFLAGS -D${3}=${4}"
			else
				LIBPREFIXDB_CFLAGS="$LIBPREFIXDB_CFLAGS -D${3}=${5}"
			fi
		}


		if test "x$prefix" = "xNONE" || test "x$prefix" = "x"; then
			LIBPREFIXDB_CFLAGS="$LIBPREFIXDB_CFLAGS -DPDB_PREFIX=\"\\\"$ac_default_prefix\\\"\""
		else
			LIBPREFIXDB_CFLAGS="$LIBPREFIXDB_CFLAGS -DPDB_PREFIX=\"\\\"$prefix\\\"\""
		fi

		checkdir "$bindir"     '${exec_prefix}/bin'          PDB_BIN     NULL "\"\\\"$bindir\\\"\""
		checkdir "$datadir"    '${prefix}/share'             PDB_SHARE   NULL "\"\\\"$datadir\\\"\""
		checkdir "$sysconfdir" '${prefix}/etc'               PDB_ETC     NULL "\"\\\"$sysconfdir\\\"\""
		checkdir "$libdir"     '${exec_prefix}/lib'          PDB_LIB     NULL "\"\\\"$libdir\\\"\""
		checkdir "$libexecdir" '${exec_prefix}/libexec'      PDB_LIBEXEC NULL "\"\\\"$libexecdir\\\"\""

		AC_SUBST(LIBPREFIXDB_CFLAGS)
		AC_SUBST(LIBPREFIXDB_LIBS)
	fi
])
