#include <stdio.h>
#include <stdlib.h>
#include <limits.h>
#ifdef ENABLE_LIBPREFIXDB
#include <prefixdb.h>
#endif /* ENABLE_LIBPREFIXDB */

#include "libfoo.h"


int
main ()
{
	char *configfile;
	FILE *f;
	char *libprefixdb_support;

	#ifdef ENABLE_LIBPREFIXDB
		PrefixDB *db;

		db = pdbInit ("@autopackage.org/tests/foobar/",
			PDB_PREFIX, PDB_BIN, PDB_SHARE,
			PDB_ETC,    PDB_LIB, PDB_LIBEXEC);
		configfile = calloc (PATH_MAX, 1);
		snprintf (configfile, PATH_MAX, "%s/foo-config", pdbGetEtc (db));
		libprefixdb_support = "yes";
	#else
		configfile = FOO_SYSCONFDIR "/foo-config";
		libprefixdb_support = "no";
	#endif /* ENABLE_LIBPREFIXDB */

	printf ("foobar version " FOOBAR_VERSION "\n");
	printf ("libprefixdb support: %s\n\n", libprefixdb_support);

	libfoo ();
	printf ("\n");
	printf ("'Configuration' file %s:\n", configfile);
	f = fopen (configfile, "r");
	if (!f)
	{
		fprintf (stderr, "cannot open file!\n");
		printf ("\nPress ENTER to exit this program.\n");
		getchar ();
		return 1;
	}

	while (!feof (f))
	{
		char data[1024 * 8 + 1];
		size_t bytes_read;

		bytes_read = fread (&data, 1, sizeof (data) - 1, f);
		data[bytes_read] = 0;
		printf ("%s", data);
	}
	fclose (f);

	printf ("\nPress ENTER to exit this program.\n");
        getchar ();
	return 0;
}
